/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import safeqclient.Configuration;
import safeqclient.Parser;
import safeqclient.SafeQClient;
import safeqclient.Server;

public class Main
extends JFrame {
    Server server;
    int jobid;
    boolean loginNeeded;
    private Dimension dim;
    private JEditorPane jEditorPane1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JScrollPane jScrollPane2;
    private JCheckBox logedin;
    private JTextField login;
    private JButton okButton;
    private JPasswordField passwordField;
    private JButton stornoButton;

    public void setEditorContentType(String type) {
        this.jEditorPane1.setContentType(type);
    }

    public void setLoginNeeded(boolean val) {
        this.loginNeeded = val;
        if (val) {
            this.passwordField.setText("");
            this.login.setEnabled(false);
            this.passwordField.setEnabled(false);
        } else {
            this.login.setEnabled(true);
            this.passwordField.setEnabled(true);
        }
    }

    public void setType(String type) {
        if (type.equalsIgnoreCase("info_only")) {
            this.jLabel2.setVisible(false);
            this.jLabel3.setVisible(false);
            this.logedin.setVisible(false);
            this.login.setVisible(false);
            this.okButton.setVisible(false);
            this.passwordField.setVisible(false);
            this.stornoButton.setVisible(false);
        } else {
            this.jLabel2.setVisible(true);
            this.jLabel3.setVisible(true);
            this.logedin.setVisible(true);
            this.login.setVisible(true);
            this.okButton.setVisible(true);
            this.passwordField.setVisible(true);
            this.stornoButton.setVisible(true);
        }
    }

    public void setText(String s) {
        this.jEditorPane1.setText(s);
    }

    public void setEditor(EditorKit ek) {
        this.jEditorPane1.setEditorKit(ek);
    }

    public Document getDocument() {
        return this.jEditorPane1.getDocument();
    }

    public void setJobId(int id) {
        this.jobid = id;
    }

    public Main(Server s, boolean rememberUser) {
        this.initComponents();
        this.logedin.setSelected(rememberUser);
        this.logedin.setEnabled(rememberUser);
        this.server = s;
        this.setTitle(Configuration.getProperty(Configuration.PRG_TITLE));
        this.dim = this.jEditorPane1.getSize();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                Main.this.setVisible(false);
            }
        });
    }

    public void viewDialog(Parser p) {
        int type = 2;
        if (p.getType().compareTo(Configuration.getProperty(Configuration.TYPE_WARNING)) == 0) {
            type = 2;
        }
        if (p.getType().compareTo(Configuration.getProperty(Configuration.TYPE_INFO)) == 0) {
            type = 1;
        }
        if (p.getType().compareTo(Configuration.getProperty(Configuration.TYPE_ERROR)) == 0) {
            type = 0;
        }
        if (p.getType().compareTo("") == 0) {
            type = -1;
        }
        if (p.isShow()) {
            this.setVisible(true);
        }
        JOptionPane.showMessageDialog(this, p.getText().replaceAll("\\|", "\r\n"), p.getType(), type);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.okButton = new JButton();
        this.stornoButton = new JButton();
        this.login = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.logedin = new JCheckBox();
        this.passwordField = new JPasswordField();
        this.jScrollPane2 = new JScrollPane();
        this.jEditorPane1 = new JEditorPane();
        this.setDefaultCloseOperation(0);
        this.setTitle("SafeQ Client");
        this.setAlwaysOnTop(true);
        this.setIconImage(SafeQClient.createImage(Configuration.getProperty(Configuration.ICON_INIT), "tray icon"));
        this.jLabel1.setText("Info:");
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.okButtonActionPerformed(evt);
            }
        });
        this.stornoButton.setText("Stornovat \u00falohu");
        this.stornoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.stornoButtonActionPerformed(evt);
            }
        });
        this.login.setColumns(7);
        this.jLabel2.setText("Osobn\u00ed \u010d\u00edslo:");
        this.jLabel3.setText("Heslo:");
        this.logedin.setSelected(true);
        this.logedin.setText("Pou\u017e\u00edt p\u0159ihl\u00e1\u0161en\u00ed i pro n\u00e1sleduj\u00edc\u00ed \u00falohy");
        this.logedin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Main.this.logedinActionPerformed(evt);
            }
        });
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                Main.this.passwordFieldKeyPressed(evt);
            }
        });
        this.jEditorPane1.setEditable(false);
        this.jEditorPane1.setFont(new Font("Times New Roman", 0, 12));
        this.jEditorPane1.setCursor(new Cursor(2));
        this.jEditorPane1.setFocusCycleRoot(false);
        this.jEditorPane1.setFocusable(false);
        this.jScrollPane2.setViewportView(this.jEditorPane1);
        this.jEditorPane1.getAccessibleContext().setAccessibleName("");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(29, 29, 29).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.login, -2, 71, -2)).addGap(49, 49, 49).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.passwordField, -2, 152, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.okButton).addGap(18, 18, 18).addComponent(this.stornoButton).addGap(18, 18, 18)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3).addContainerGap()))).addGroup(layout.createSequentialGroup().addComponent(this.logedin).addGap(0, 0, Short.MAX_VALUE)))).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 157, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stornoButton).addComponent(this.okButton).addComponent(this.login, -2, -1, -2).addComponent(this.passwordField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logedin).addContainerGap()));
        this.pack();
    }

    private void okPressed() {
        this.server.Auth(this.login.getText(), new String(this.passwordField.getPassword()), this.logedin.isSelected(), this.jobid);
        this.passwordField.setText("");
        this.setVisible(false);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.okPressed();
    }

    private void stornoButtonActionPerformed(ActionEvent evt) {
        this.server.AuthReject(this.jobid);
        this.setVisible(false);
    }

    private void logedinActionPerformed(ActionEvent evt) {
        if (this.loginNeeded) {
            if (this.logedin.isSelected()) {
                this.passwordField.setText("");
                this.login.setEnabled(false);
                this.passwordField.setEnabled(false);
            } else {
                this.login.setText("");
                this.passwordField.setText("");
                this.login.setEnabled(true);
                this.passwordField.setEnabled(true);
            }
        }
    }

    private void passwordFieldKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10 || evt.getKeyCode() == 13) {
            this.okPressed();
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }
}

