/*
 * Decompiled with CFR 0.152.
 */
package safeqclient;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import safeqclient.Configuration;
import safeqclient.SafeQClient;

public class Connection {
    Socket requestSocket;
    PrintStream out;
    ObjectInputStream in;
    String message;
    String address;
    int port;
    long time = System.currentTimeMillis();
    boolean isConnected;

    Connection(String addr, int p) {
        this.address = addr;
        this.port = p;
        this.isConnected = false;
    }

    public boolean isConnected() {
        if (!this.isConnected) {
            return false;
        }
        int val = Integer.valueOf(Configuration.getProperty(Configuration.TIMEOUT));
        if (System.currentTimeMillis() - this.time > (long)val) {
            this.isConnected = false;
            this.setIcon(Configuration.ICON_ERR);
        }
        return this.isConnected;
    }

    public void setConnected(boolean b) {
        this.isConnected = b;
    }

    public void setIcon(String icon) {
        SafeQClient.trayIcon.setImage(SafeQClient.createImage(Configuration.getProperty(icon), "tray icon"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void openConnection() {
        if (this.isConnected) {
            return;
        }
        this.isConnected = true;
        try {
            this.requestSocket = new Socket();
            this.requestSocket.connect(new InetSocketAddress(this.address, this.port), 10000);
            this.out = new PrintStream(this.requestSocket.getOutputStream());
            this.requestSocket.setKeepAlive(true);
            while (SafeQClient.trayIcon == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {}
            }
            this.setIcon(Configuration.ICON_OK);
            this.isConnected = true;
            this.resetTimer();
        }
        catch (UnknownHostException unknownHost) {
            System.err.println(Configuration.getProperty(Configuration.CONNECTION_ERROR));
            while (SafeQClient.trayIcon == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {}
            }
            this.closeConnection();
            this.setIcon(Configuration.ICON_ERR);
            this.isConnected = false;
        }
        catch (SocketException io) {
            io.getMessage();
            while (SafeQClient.trayIcon == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception e) {}
            }
            this.closeConnection();
            this.isConnected = false;
        }
        catch (Exception io) {
            io.getMessage();
            while (SafeQClient.trayIcon == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            this.closeConnection();
            this.isConnected = false;
        }
    }

    public void resetTimer() {
        this.time = System.currentTimeMillis();
    }

    public void closeConnection() {
        try {
            this.in.close();
            this.out.close();
            this.requestSocket.close();
        }
        catch (Exception ioException) {
            System.out.println(Configuration.getProperty(Configuration.CONNECTION_ERROR));
        }
    }

    void sendMessage(String msg) {
        try {
            this.out.print(msg);
            this.out.flush();
            if (this.out.checkError()) {
                if (this.isConnected) {
                    this.closeConnection();
                }
                this.isConnected = false;
            }
        }
        catch (Exception ioException) {
            ioException.printStackTrace();
            this.setIcon(Configuration.ICON_ERR);
            this.closeConnection();
            this.isConnected = false;
            System.out.println(ioException.getMessage());
        }
    }

    String receiveMessage() {
        String out = new String();
        try {
            InputStream ins = this.requestSocket.getInputStream();
            int count = ins.available();
            if (count > 0) {
                do {
                    byte[] array = new byte[count];
                    this.time = System.currentTimeMillis();
                    for (int i = 0; i < count; ++i) {
                        array[i] = (byte)ins.read();
                    }
                    out = out.concat(new String(array, "cp1250"));
                } while ((count = ins.available()) > 0);
            }
        }
        catch (Exception e) {
            System.out.println("Chyba cteni: " + e.getMessage());
            this.setIcon(Configuration.ICON_ERR);
            this.closeConnection();
            this.isConnected = false;
        }
        return out;
    }
}

