/*
 * Decompiled with CFR 0.152.
 */
package safeqclient;

import java.awt.AWTException;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import safeqclient.Configuration;
import safeqclient.Server;

public class SafeQClient {
    public static TrayIcon trayIcon = null;
    private static Server s;

    public static void main(String[] args) {
        boolean rememberUser = true;
        Configuration.init("safeq");
        if (args.length > 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].compareToIgnoreCase("forgetUser") == 0) {
                    rememberUser = false;
                }
                if (args[i].compareToIgnoreCase("-forgetUser") != 0) continue;
                rememberUser = false;
            }
        }
        UIManager.put("swing.boldMetal", Boolean.FALSE);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SafeQClient.createAndShowGUI();
            }
        });
        try {
            Thread.sleep(500L);
        }
        catch (Exception e) {
            // empty catch block
        }
        s = new Server(Configuration.getProperty(Configuration.URL), Integer.valueOf(Configuration.getProperty(Configuration.PORT)), rememberUser);
        s.start();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(Integer.valueOf(Configuration.getProperty(Configuration.TIMEOUT)) / 2);
                    s.Nop();
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private static void createAndShowGUI() {
        if (!SystemTray.isSupported()) {
            System.out.println("SystemTray is not supported");
            return;
        }
        PopupMenu popup = new PopupMenu();
        trayIcon = new TrayIcon(SafeQClient.createImage(Configuration.getProperty(Configuration.ICON_INIT), "tray icon"));
        final SystemTray tray = SystemTray.getSystemTray();
        MenuItem aboutItem = new MenuItem("About");
        MenuItem reJob = new MenuItem("Noauth. jobs");
        MenuItem jobListItem = new MenuItem("Job List");
        MenuItem historyItem = new MenuItem("History");
        MenuItem webItem = new MenuItem("SafeQ web");
        MenuItem exitItem = new MenuItem("Exit");
        popup.add(aboutItem);
        popup.add(reJob);
        popup.add(jobListItem);
        popup.add(historyItem);
        popup.add(webItem);
        popup.addSeparator();
        popup.add(exitItem);
        trayIcon.setPopupMenu(popup);
        trayIcon.setImageAutoSize(true);
        try {
            tray.add(trayIcon);
        }
        catch (AWTException e) {
            System.out.println("TrayIcon could not be added.");
            return;
        }
        trayIcon.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int o = JOptionPane.showConfirmDialog(null, "SafeQ Client v. " + Configuration.getProperty(Configuration.VERSION_NUM) + "\r\n" + Configuration.getProperty(Configuration.EXIT), "Warning", 2, 0);
                if (o == 0) {
                    System.exit(0);
                }
            }
        });
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(null, Configuration.getProperty(Configuration.ABOUT) + " " + Configuration.getProperty(Configuration.VERSION_NUM) + "\r\nP\u0159ipom\u00ednky zas\u00edlejte na email: safeq@vsb.cz");
            }
        });
        jobListItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                s.JobList();
            }
        });
        historyItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String historyPage = Configuration.getProperty(Configuration.PAGE_HISTORY);
                try {
                    Desktop.getDesktop().browse(URI.create(historyPage));
                }
                catch (Exception exc) {
                    System.out.println(exc.getMessage());
                }
            }
        });
        reJob.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                s.ReJob();
            }
        });
        webItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String webPage = Configuration.getProperty(Configuration.PAGE_WEB);
                try {
                    Desktop.getDesktop().browse(URI.create(webPage));
                }
                catch (Exception exc) {
                    System.out.println(exc.getMessage());
                }
            }
        });
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                tray.remove(trayIcon);
                System.exit(0);
            }
        });
    }

    public static Image createImage(String path, String description) {
        URL imageURL = SafeQClient.class.getResource(path);
        if (imageURL == null) {
            System.err.println("Resource not found: " + path);
            return null;
        }
        return new ImageIcon(imageURL, description).getImage();
    }
}

