/*
 * Decompiled with CFR 0.152.
 */
package safeqclient;

import gui.Main;
import java.awt.TrayIcon;
import java.io.ByteArrayInputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.rtf.RTFEditorKit;
import safeqclient.Configuration;
import safeqclient.Connection;
import safeqclient.Parser;
import safeqclient.SafeQClient;

public class Server
extends Thread {
    Connection connection;
    String pcName;
    Parser p;
    Main gui;
    boolean restart;
    boolean sec;
    long time;
    boolean rememberUser;

    public String getPcName() {
        return this.pcName;
    }

    public boolean getIsConnected() {
        return this.connection.isConnected();
    }

    public Server(String url, int port, boolean remUser) {
        this.connection = new Connection(url, port);
        this.pcName = System.getProperty("user.name");
        this.rememberUser = remUser;
    }

    public void Connect() {
        if (this.connection.isConnected()) {
            return;
        }
        String command = Configuration.getProperty(Configuration.VERSION) + Configuration.getProperty(Configuration.VERSION_NUM) + "\r\n" + Configuration.getProperty(Configuration.LOGIN) + this.pcName + "\r\n" + Configuration.getProperty(Configuration.ACTION) + Configuration.getProperty(Configuration.ACTION_CONNECT) + "\r\n";
        while (!this.connection.isConnected()) {
            this.connection.openConnection();
            if (this.connection.isConnected()) {
                this.connection.sendMessage(command);
            }
            try {
                Thread.sleep(8000L);
            }
            catch (Exception exception) {}
        }
    }

    public void Nop() {
        String command = Configuration.getProperty(Configuration.VERSION) + Configuration.getProperty(Configuration.VERSION_NUM) + "\r\n" + Configuration.getProperty(Configuration.LOGIN) + this.pcName + "\r\n" + Configuration.getProperty(Configuration.ACTION) + Configuration.getProperty(Configuration.ACTION_NOP) + "\r\n";
        int val = Integer.valueOf(Configuration.getProperty(Configuration.TIMEOUT));
        if (System.currentTimeMillis() - this.time > (long)val) {
            this.connection.setConnected(false);
        }
        while (!this.connection.isConnected()) {
            this.Connect();
            try {
                Thread.sleep(8000L);
            }
            catch (Exception exception) {}
        }
        this.connection.sendMessage(command);
    }

    public void ReJob() {
        String command = Configuration.getProperty(Configuration.VERSION) + Configuration.getProperty(Configuration.VERSION_NUM) + "\r\n" + Configuration.getProperty(Configuration.LOGIN) + System.getProperty("user.name") + "\r\n" + Configuration.getProperty(Configuration.ACTION) + Configuration.getProperty(Configuration.ACTION_REJOB) + "\r\n";
        this.connection.sendMessage(command);
    }

    public void JobList() {
        String command = Configuration.getProperty(Configuration.VERSION) + Configuration.getProperty(Configuration.VERSION_NUM) + "\r\n" + Configuration.getProperty(Configuration.LOGIN) + System.getProperty("user.name") + "\r\n" + Configuration.getProperty(Configuration.ACTION) + Configuration.getProperty(Configuration.ACTION_JOBLIST) + "\r\n";
        this.connection.sendMessage(command);
    }

    public void Auth(String user, String passwd, boolean logedin, int jobid) {
        String command = Configuration.getProperty(Configuration.VERSION) + Configuration.getProperty(Configuration.VERSION_NUM) + "\r\n" + Configuration.getProperty(Configuration.LOGIN) + System.getProperty("user.name") + "\r\n" + Configuration.getProperty(Configuration.ACTION) + Configuration.getProperty(Configuration.ACTION_AUTH) + "\r\n";
        String pass = passwd.length() > 0 ? this.encrypt(passwd.getBytes(), (user + "@" + this.pcName + ":" + jobid).getBytes()) : "";
        command = command + Configuration.getProperty(Configuration.USER) + user + "\r\n" + Configuration.getProperty(Configuration.PASS) + pass + "\r\n";
        command = command + Configuration.getProperty(Configuration.LOGEDIN) + (logedin ? -1 : 0) + "\r\n" + Configuration.getProperty(Configuration.JOBID) + jobid + "\r\n";
        this.connection.sendMessage(command);
    }

    public void AuthReject(int jobid) {
        String command = Configuration.getProperty(Configuration.VERSION) + Configuration.getProperty(Configuration.VERSION_NUM) + "\r\n" + Configuration.getProperty(Configuration.LOGIN) + System.getProperty("user.name") + "\r\n" + Configuration.getProperty(Configuration.ACTION) + Configuration.getProperty(Configuration.ACTION_REJECT) + "\r\n" + Configuration.getProperty(Configuration.JOBID) + jobid + "\r\n";
        this.connection.sendMessage(command);
    }

    public String receiveMessage() {
        return this.connection.receiveMessage();
    }

    public void hint(Parser p) {
        TrayIcon.MessageType type = TrayIcon.MessageType.NONE;
        if (p.getType().compareTo(Configuration.getProperty(Configuration.TYPE_INFO)) == 0) {
            type = TrayIcon.MessageType.INFO;
        }
        if (p.getType().compareTo(Configuration.getProperty(Configuration.TYPE_ERROR)) == 0) {
            type = TrayIcon.MessageType.ERROR;
        }
        if (p.getType().compareTo(Configuration.getProperty(Configuration.TYPE_WARNING)) == 0) {
            type = TrayIcon.MessageType.WARNING;
        }
        SafeQClient.trayIcon.displayMessage("SafeQ Client - " + p.getTitle(), p.getText(), type);
    }

    @Override
    public void run() {
        boolean cont = true;
        this.Connect();
        this.restart = false;
        this.gui = new Main(this, this.rememberUser);
        this.gui.setVisible(false);
        this.p = new Parser();
        this.time = System.currentTimeMillis();
        while (cont) {
            String input = this.receiveMessage();
            if (!input.isEmpty()) {
                this.time = System.currentTimeMillis();
                this.p.parse(input);
                if (this.p.getAction().compareTo(Configuration.getProperty(Configuration.ACTION_END)) == 0) {
                    System.exit(0);
                }
                if (this.p.getAction().compareTo(Configuration.getProperty(Configuration.ACTION_NEWJOB)) == 0) {
                    this.newJob(this.p);
                }
                if (this.p.getAction().compareTo(Configuration.getProperty(Configuration.ACTION_JOBLIST)) == 0) {
                    this.jobList(this.p);
                }
                if (this.p.getAction().compareTo(Configuration.getProperty(Configuration.ACTION_MESSAGE)) == 0) {
                    this.gui.viewDialog(this.p);
                }
                if (this.p.getAction().compareTo(Configuration.getProperty(Configuration.ACTION_HINT)) == 0) {
                    this.hint(this.p);
                }
            }
            if (!this.connection.isConnected()) {
                this.connection.closeConnection();
                this.Connect();
            }
            try {
                Server.sleep(1000L);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }

    private void jobList(Parser p) {
        String rtf = null;
        rtf = p.getJob();
        rtf = rtf.replaceAll("\\|", "\r\n");
        this.gui.setType("info_only");
        String html = this.convertToHtml(this.conertRtfToText(rtf));
        this.gui.setEditorContentType("text/html");
        HTMLEditorKit htmlParser = new HTMLEditorKit();
        this.gui.setEditor(htmlParser);
        this.gui.setVisible(true);
        this.gui.setAlwaysOnTop(true);
        ByteArrayInputStream is = new ByteArrayInputStream(html.getBytes());
        try {
            htmlParser.read(is, this.gui.getDocument(), 0);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    private void newJob(Parser p) {
        String rtf = null;
        rtf = p.getJob();
        rtf = rtf.replaceAll("\\|", "\r\n");
        this.gui.setType("no_info_only");
        this.gui.setJobId(p.getJobid());
        this.gui.setVisible(true);
        this.gui.setAlwaysOnTop(true);
        this.gui.setLoginNeeded(!p.isReauth());
        this.gui.setEditorContentType("text/plain");
        this.gui.setText(this.conertRtfToText(rtf));
    }

    public String encrypt(byte[] messageBytes, byte[] key) {
        byte[] toCode;
        String out = null;
        String finalOut = null;
        if (messageBytes.length % 16 != 0) {
            toCode = new byte[messageBytes.length + (16 - messageBytes.length % 16)];
            for (int i = 0; i < messageBytes.length; ++i) {
                toCode[i] = messageBytes[i];
            }
        } else {
            toCode = messageBytes;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            key = md.digest(key);
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(toCode);
            char[] hexArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
            char[] hexChars = new char[encrypted.length * 2];
            for (int j = 0; j < encrypted.length; ++j) {
                int v = encrypted[j] & 0xFF;
                hexChars[j * 2] = hexArray[v >>> 4];
                hexChars[j * 2 + 1] = hexArray[v & 0xF];
            }
            out = new String(hexChars);
            String hex = Integer.toHexString(messageBytes.length);
            if (hex.length() < 8) {
                char[] chars = new char[8 - hex.length()];
                for (int i = 0; i < chars.length; ++i) {
                    chars[i] = 48;
                }
                hex = new String(chars).concat(hex);
            }
            finalOut = new String();
            for (int i = 0; i < hex.length() / 2; ++i) {
                finalOut = finalOut.concat(hex.substring(6 - i * 2, 8 - i * 2));
            }
            finalOut = finalOut.concat(out);
        }
        catch (GeneralSecurityException e) {
            System.out.println(e.getMessage());
        }
        return finalOut;
    }

    private String conertRtfToText(String rtf) {
        ByteArrayInputStream bais = new ByteArrayInputStream(rtf.getBytes());
        String s = null;
        try {
            RTFEditorKit rtfParser = new RTFEditorKit();
            Document document = rtfParser.createDefaultDocument();
            rtfParser.read(bais, document, 0);
            s = document.getText(0, document.getLength());
            int[] intArray = new int[s.length()];
            for (int i = 0; i < s.length(); ++i) {
                intArray[i] = s.charAt(i);
                if (intArray[i] == 236) {
                    intArray[i] = 283;
                }
                if (intArray[i] == 232) {
                    intArray[i] = 269;
                }
                if (intArray[i] == 248) {
                    intArray[i] = 345;
                }
                if (intArray[i] == 249) {
                    intArray[i] = 367;
                }
                if (intArray[i] == 217) {
                    intArray[i] = 366;
                }
                if (intArray[i] == 239) {
                    intArray[i] = 271;
                }
                if (intArray[i] == 207) {
                    intArray[i] = 270;
                }
                if (intArray[i] == 204) {
                    intArray[i] = 282;
                }
                if (intArray[i] == 200) {
                    intArray[i] = 268;
                }
                if (intArray[i] != 216) continue;
                intArray[i] = 344;
            }
            s = new String(intArray, 0, intArray.length);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return s;
    }

    private String convertToHtml(String txt) {
        Character character;
        char ch;
        int i;
        String html = null;
        html = "<HTML>\n\r<HEAD>\n\r</HEAD>\n\r<BODY>\n\r";
        html = html.concat("<TABLE>\n\r");
        html = html.concat("<TR><TH nowrap>");
        for (i = 0; i < txt.length(); ++i) {
            ch = txt.charAt(i);
            character = new Character(ch);
            if (ch == '\n') {
                ++i;
                break;
            }
            html = ch == '\t' ? html.concat("</TH><TH nowrap>") : html.concat(character.toString());
        }
        html = html.concat("</TH></TR>\n\r<TR><TD nowrap>");
        while (i < txt.length()) {
            ch = txt.charAt(i);
            character = new Character(ch);
            html = ch == '\n' ? html.concat("</TD></TR>\n\r<TR><TD nowrap>") : (ch == '\t' ? html.concat("</TD><TD nowrap align=\"center\">") : html.concat(character.toString()));
            ++i;
        }
        html = html.concat("</TD></TR>\n\r");
        html = html.concat("</TABLE>\n\r");
        html = html.concat("</BODY></HTML>\n\r");
        return html;
    }
}

